<?php

namespace JLGR\Followables\Queries;

use AviatorsEcho\Models\User;
use JLGR\Followables\Enums\FollowStatus;
use JLGR\Followables\Queries\BaseQuery;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;

class Followers extends BaseQuery
{

	/**
	 * Build a query for fetching the followers of the
	 * authenticated user.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Illuminate\Database\Eloquent\Builder
	 */
	protected static function builder (array $params = []) : Builder
	{
		// Id of the user to get the followers for. If no useId is given, we
		// assume the followers of the authenticated user should be fetched.
		$userId = $params['recordId'] ?? Auth::id();
		
		// Build a query to fetch all followers from the authenticated user.
		$followers = User::query()
		
			// Select all user data.
			->select('users.*')

			// Join over the followables table.
			->join('followables', function ($query) use ($userId)
			{	
				$query

					// Build join.
					->on('users.id', '=', 'followables.follower_id')

					// Filter for the authenciated user.
					->where('followables.followable_id', '=', $userId)

					// Only accepted followers.
					->where('followables.status', FollowStatus::FOLLOWING);
			})

			// Ignore users that are scheduled for deletion.
			->whereNull('deletion_scheduled_at')

			// Order by user name.
			->orderBy('name');
			
		// Return the query builder instance.
		return static::newQuery($followers);
	}

}