<?php

namespace JLGR\Followables\Queries;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Pagination\LengthAwarePaginator;

class BaseQuery
{

	/**
	 * Create a new builder instance and check if the global user scope should
	 * be disabled (if applicable).
	 * 
	 * @param mixed Illuminate\Database\Eloquent\Builder $builder
	 * 
	 * @return Illuminate\Database\Eloquent\Builder
	 */
	protected static function newQuery ($builder) : Builder
	{
		return $builder;
	}

	/**
	 * Return Eloquent collection.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Illuminate\Database\Eloquent\Collection
	 */
	public static function collection (array $params = []) : Collection
	{
		return static::builder($params)->get();
	}

	/**
	 * Return Eloquent builder.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Illuminate\Database\Eloquent\Builder
	 */
	public static function query (array $params = []) : Builder
	{
		return static::builder($params);
	}

	/**
	 * Return single Eloquent model.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Illuminate\Database\Eloquent\Model
	 */
	public static function first (array $params = []) : Model
	{
		return static::builder($params)->first();
	}

	/**
	 * Return paginated collection with Eloquent models.
	 * 
	 * @param integer $perPage Optional integer with the number of items per page.
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Illuminate\Database\Eloquent\Model
	 */
	public static function paginate ($perPage = 10, array $params = []) : LengthAwarePaginator
	{
		return static::builder($params)->paginate($perPage);
	}

	/**
	 * Return fast paginated collection with Eloquent models.
	 * 
	 * @param integer $perPage Optional integer with the number of items per page.
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Illuminate\Database\Eloquent\Model
	 */
	public static function fastPaginate ($perPage = 10, array $params = [])
	{
		return static::builder($params)->fastPaginate($perPage);
	}

	/**
	 * Return the nimber of models.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return int
	 */
	public static function count (array $params = []) : int
	{
		return static::builder($params)->count();
	}

	/**
	 * Check if there are models present.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return boolean
	 */
	public static function exists (array $params = []) : bool
	{
		return static::builder($params)->count() > 0;
	}

	/**
	 * Set the given user id on the base query class.
	 * 
	 * @param integer $userId
	 * 
	 * @return self
	 */
	public static function forUser ($userId = null)
	{
		static::$userId = $userId;

		return new static;
	}

}
