<?php

namespace JLGR\Followables\Observers;

use JLGR\Followables\Models\Followable;
use Illuminate\Support\Facades\Cache;

class FollowableObserver
{

	/**
	 * Handle the Followable "created" event.
	 *
	 * @param \AviatorsEcho\Packages\Following\Models\Followable $followable
	 * 
	 * @return void
	 */
	public function created (Followable $followable)
	{
        // Invalidate cache.
        //$this->invalidateCache($followable);
	}

	/**
	 * Handle the Followable "updated" event.
	 *
	 * @param \AviatorsEcho\Packages\Following\Models\Followable $followable
	 * 
	 * @return void
	 */
	public function updated (Followable $followable)
	{
        // Invalidate cache.
        //$this->invalidateCache($followable);
	}

	/**
	 * Handle the Followable "deleted" event.
	 * 
	 * @param \AviatorsEcho\Packages\Following\Models\Followable $followable
	 * 
	 * @return void
	 */
	public function deleted (Followable $followable)
	{
        // Invalidate cache.
        //$this->invalidateCache($followable);
	}

    /**
     * Invalidate cache.
     * 
     * @return void
     */
    private function invalidateCache ($followable)
    {
        // Get all involved users.
		$involvedUsers = [
			$followable->follower_id,
			$followable->followable_id
		];
		
		// Flush cache for all involved users.
		foreach ($involvedUsers as $involvedUser)
		{
			// Prepare user tag.
			$user = 'user:' . $involvedUser;
			$tag = $user . '__aviators';
			
			// Flush...
			Cache::tags([ $tag, $user ])->flush();
		}
    }

}
