<?php

namespace JLGR\Followables\Livewire;

use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\{ Computed, On };
use Livewire\Component;

class PrivateProfileMessage extends Component
{

	/**
	 * The given user / aviator.
	 * 
	 * @var \AviatorsEcho\Models\User
	 */
	public $aviator;

	/**
	 * The user viewing the given user/ aviator.
	 * 
	 * @var \AviatorsEcho\Models\User
	 */
	public $viewingUser;

	/**
	 * Template.
	 * 
	 * @var string
	 */
	public $template = 'default';
	
	/**
	 * Mount the component.
	 * 
	 * @return void
	 */
	public function mount ($aviator) : void
	{
		$this->aviator = $aviator;

		$this->viewingUser = Auth::user();
	}

	/**
	 * Flag indicating the authenticated user has requested to follow the given user.
	 * 
	 * @return bool
	 */
	#[ Computed ]
	public function hasRequestedToFollow () : bool
	{
		return $this->viewingUser->hasRequestedToFollow($this->aviator);
	}

	/**
	 * Date of the follow request (if present).
	 * 
	 * @return string|null
	 */
	#[ Computed, On('follow-action') ]
	public function followRequestDate () : string | null
	{
		return $this->viewingUser->getFollowRequestDate($this->aviator);
	}

	/**
	 * Cancel follow request.
	 * 
	 * @return void
	 */
	public function cancelFollowRequest ()
	{
		$this->viewingUser->cancelFollowRequest($this->aviator);

		$this->dispatch('follow-action');
	}
	
	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view("followables::livewire.private-profile-message.{$this->template}");
	}

}
