<?php
 
namespace JLGR\Followables\Listeners;

use JLGR\Followables\Events\Unfollowed as UnfollowedEvent;
use JLGR\Followables\Jobs\SomeoneUnfollowedMe;

class DispatchUnfollowedNotificationJob
{

	/**
	 * Handle the event.
	 *
	 * @param \AviatorsEcho\Packages\Following\Events\Unfollowed $event
	 * 
	 * @return void
	 */
	public function handle (UnfollowedEvent $event)
	{
		// Notify the user being followed.
		SomeoneUnfollowedMe::dispatch(
			$event->follower->id,		// The user that has unfollowed the other user.
			$event->following->id		// The user being unfollowed by the first user.
		);
	}

}
