<?php
 
namespace JLGR\Followables\Listeners;

use JLGR\Followables\Events\Followed as FollowedEvent;
use JLGR\Followables\Jobs\SomeoneIsFollowingMe;

class DispatchFollowedNotificationJob
{

	/**
	 * Handle the event.
	 *
	 * @param \AviatorsEcho\Packages\Following\Events\Followed $event
	 * 
	 * @return void
	 */
	public function handle (FollowedEvent $event)
	{
		// Notify the user being followed.
		SomeoneIsFollowingMe::dispatch(
			$event->follower->id,		// The user that follows the other user (following).
			$event->following->id,		// The user being followed by the first user.
			$event->isRequested
		);
	}

}
