<?php

namespace JLGR\Followables\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SomeoneUnfollowedMe implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * Follower id.
	 * 
	 * @var integer
	 */
	protected $followerId;

	/**
	 * Following id.
	 * 
	 * @var integer
	 */
	protected $followingId;

	/**
	 * Create a new job instance.
	 * 
	 * @param  integer  $userId
	 * 
	 * @return void
	 */
	public function __construct ($followerId, $followingId)
	{
		$this->followerId = $followerId;			// The user that unfollowed the other user.
		$this->followingId = $followingId;			// The user being unfollowed by the first user.

		$this->onQueue('social-interaction');
	}

	/**
	 * Execute the job.
	 * Will be processed on the worker server.
	 * 
	 * @return void
	 */
	public function handle () : void {}

}
