<div class="flex flex-1 flex-col gap-y-2">

	@if ($viewingUser->hasBlocked($aviator))

		<x-filament::button wire:click="unblock" color="secondary">
			{{ __('Unblock aviator') }}
		</x-filament::button>

	@elseif ($viewingUser->isFollowing($aviator))

		<x-filament::button wire:click="unfollow" color="secondary" icon="heroicon-o-user-plus">
			{{ __('Unfollow aviator') }}
		</x-filament::button>

	@elseif ($viewingUser->hasRequestedToFollow($aviator))

		<x-filament::button wire:click="cancelFollowRequest" color="secondary" icon="heroicon-o-user-minus">
			{{ __('Cancel follow request') }}
		</x-filament::button>

	@else

		@if ($aviator->hasPublicProfile())
			<x-filament::button wire:click="follow" icon="heroicon-o-user-plus">
				{{ __('Follow aviator') }}
			</x-filament::button>
		@elseif ($aviator->isVisibleForFollowers())
			<x-filament::button wire:click="follow" icon="heroicon-o-user-plus">
				{{ __('Request to follow aviator') }}
			</x-filament::button>
		@endif

	@endif

</div>
