<?php

namespace JLGR\Followables\Queries;

use Illuminate\Database\Eloquent\Builder;
use AviatorsEcho\Models\User;
use JLGR\Followables\Enums\FollowStatus;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class MutualFollowings extends BaseQuery
{

	/**
     * Build a query for fetching the followers of the
     * authenticated user.
     *
     * @param array $params Optional array with filter params.
     *
     * @return Builder
     */
    public static function builder (array $params = [])
	{
		// Get id's of the authenticated and viewed user.
		$authenticatedUserId = Auth::id();
		$viewedUserId = $params['recordId'];
	
		// Find mutual friends between the authenticated user and the viewed user.
		$mutualFriendsIds = DB::table('followables as f1')
			->join('followables as f2', 'f1.followable_id', '=', 'f2.followable_id')
			->where('f1.follower_id', $authenticatedUserId)
			->where('f2.follower_id', $viewedUserId)
			->where('f1.followable_id', '!=', $authenticatedUserId) // Exclude self
			->distinct()
			->pluck('f1.followable_id');
	
		// Get user details for mutual friends.
		$mutualFollowings = User::query()
			->whereIn('id', $mutualFriendsIds)
			->when($params['limit'] ?? false, fn ($query, $limit)
				=> $query
					->limit($limit));
		
		// Return the query builder instance.
		return static::newQuery($mutualFollowings);
	}

}