<?php

namespace JLGR\Followables\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class UnfollowedNotification extends Notification implements ShouldQueue
{
	use Queueable;
 
	/**
	 * The follower.
	 *
	 * @var \AviatorsEcho\Models\User
	 */
	protected $follower;

	/**
	 * Create a new notification instance.
	 *
	 * @return void
	 */
	public function __construct ($follower)
	{
		$this->follower = $follower;
	}

	/**
	 * Get the notification's delivery channels.
	 *
	 * @param  mixed  $notifiable
	 * 
	 * @return array
	 */
	public function via ($notifiable)
	{
		return [ 'mail' ];
	}

	/**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     *
     * @return MailMessage
     */
    public function toMail ($notifiable)
	{
		return (new MailMessage)
			->from(config('mail.identities.app.address'), config('mail.identities.app.address'))
			->subject($this->getSubject())
			->markdown($this->getEmailTemplate(), [
				'follower' => $this->follower->name,
				'followerId' => $this->follower->id,
			]);
	}

	/**
	 * Get the array representation of the notification.
	 *
	 * @param  mixed  $notifiable
	 * 
	 * @return array
	 */
	public function toArray ($notifiable)
	{
		return [];
	}
	
	/**
	 * Determine which queues should be used for each notification channel.
	 *
	 * @return array
	 */
	public function viaQueues ()
	{
		return [
			'mail' => 'mail-queue',
		];
	}

	/**
	 * Determine the correct email template for this notification.
	 * 
	 * @return string
	 */
	protected function getEmailTemplate ()
	{
		return 'packages.following.emails.unfollowed-notification';
	}

	/**
	 * Format subject.
	 * 
	 * @return string
	 */
	protected function getSubject ()
	{
		return __(':follower is not longer following you!', [ 'follower' => $this->follower->name ]);
	}

}
