<?php

namespace JLGR\Followables\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SomeoneIsFollowingMe implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * Follower id.
	 * 
	 * @var integer
	 */
	protected $followerId;

	/**
	 * Following id.
	 * 
	 * @var integer
	 */
	protected $followingId;

	/**
	 * Is requested flag.
	 * 
	 * @var boolean
	 */
	protected $isRequested;

	/**
	 * Create a new job instance.
	 * 
	 * @param  integer  $userId
	 * 
	 * @return void
	 */
	public function __construct ($followerId, $followingId, $isRequested)
	{
		$this->followerId = $followerId;			// The user that follows the other user (following).
		$this->followingId = $followingId;			// The user being followed by the first user.
		$this->isRequested = $isRequested;

		$this->onQueue('social-interaction');
	}

	/**
	 * Execute the job.
	 * Will be processed on the worker server.
	 * 
	 * @return void
	 */
	public function handle () : void {}

}
