<?php
 
namespace JLGR\Followables\Events;

use JLGR\Followables\Models\Followable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
 
class Followed
{
	use Dispatchable;
	use InteractsWithSockets;
	use SerializesModels;
 
	/**
	 * The follower.
	 *
	 * @var \AviatorsEcho\Models\User
	 */
	public $follower;
 
	/**
	 * The user being followed.
	 *
	 * @var \AviatorsEcho\Models\User
	 */
	public $following;
 
	/**
	 * Flag indicating the follow is requested due to privacy settings.
	 *
	 * @var boolean
	 */
	public $isRequested = false;
 
	/**
	 * Create a new event instance.
	 *
	 * @param  \JLGR\Following\Models\Followable $followable
	 * 
	 * @return void
	 */
	public function __construct (Followable $followable)
	{
		$this->follower = $followable->follower;
		$this->following = $followable->following;
		$this->isRequested = $followable->isRequested();
	}

}
