<div>

	@if ($viewingUser->isFollowing($aviator))

		<x-filament::button wire:click="unfollow" size="sm" color="secondary">
			{{ __('Unfollow :member', [ 'member' => $aviator->firstName ]) }}
		</x-filament::button>

	@elseif ($viewingUser->hasRequestedToFollow($aviator))

		<x-filament::button wire:click="cancelFollowRequest" size="sm" color="secondary">
			{{ __('Cancel follow request') }}
		</x-filament::button>

	@else

		@if ($aviator->hasPublicProfile())
			<x-filament::button wire:click="follow" size="sm" color="secondary">
				{{ __('Follow :member', [ 'member' => $aviator->firstName ]) }}
			</x-filament::button>
		@elseif ($aviator->isVisibleForFollowers())
			<x-filament::button wire:click="follow" size="sm" color="secondary">
				{{ __('Request to follow :member', [ 'member' => $aviator->firstName ]) }}
			</x-filament::button>
		@endif

	@endif

</div>
