<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

	/**
	 * The follower_id FOLLOWS the followable_id.
	 *                 ▔▔▔▔▔▔▔
	 */


	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up ()
	{
		Schema::create('followables_notifications', function (Blueprint $table) {
			$table->id();
			$table->foreignId('follower_id')->constrained('users')->onDelete('cascade');
			$table->foreignId('followable_id')->constrained('users')->onDelete('cascade');
			$table->enum('type', [
				'followed',
				'unfollowed',
			])->default('followed');
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down ()
	{
		Schema::dropIfExists('followables_notifications');
	}

};
