<?php

namespace JLGR\FeatureRequests\Repositories;

use JLGR\Kernel\Enums\CacheDuration;
use JLGR\Kernel\Repositories\BaseRepository;
use JLGR\FeatureRequests\Enums\Status;
use JLGR\FeatureRequests\Queries\AllFeatureRequests;

class FeatureRequestRepository extends BaseRepository
{

	/**
	 * Constructor.
	 */
	public function __construct ()
	{
		// Indicates whether caching is enabled.
		$this->useCaching = config('jlgr.feature-requests.cache.enabled');

		// Get default cache tags.
		$this->cacheTag = config('jlgr.feature-requests.cache.tag');
	}

	/**
	 * Get number of new feature requests.
	 * 
	 * @param  array  $params
	 * 
	 * @return int
	 */
	public function getNumberOfNewFeatureRequests (array $params = []) : int
	{
		$params = array_merge($params, [ 'status' => Status::New ]);

		return $this->retrieveFromCache(
			cacheKey: "number-of-new-feature-requests",
			callback: fn () => AllFeatureRequests::count($params),
			duration: CacheDuration::OneHour
		);
	}
	
}
