<?php

namespace JLGR\FeatureRequests\Livewire;

use Filament\Actions\Contracts\HasActions;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Schemas\Schema;
use JLGR\FeatureRequests\Contracts\CreatesFeatureRequest;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Livewire\Component;
use JLGR\FeatureRequests\Filament\FeatureRequestFormBuilder;

class FeatureRequestForm extends Component implements HasForms, HasActions
{
	use InteractsWithActions;
    use InteractsWithForms;

	/**
	 * The form's state.
	 * 
	 * @var array
	 */
	public ?array $data = [];

	/**
	 * Flag indicating the visibility of the message sent message.
	 */
	public $messageSent = false;
	
	/**
	 * Submit the form.
	 * 
	 * @return void
	 */
	public function submitForm (CreatesFeatureRequest $processor) : void
	{
		$this->validate();

		$processor->createFeatureRequest($this->data);

		$this->reset('data');
		$this->messageSent = true;

		// Notification::make()
		// 	->title(__('Feature request sent successfully!'))
		// 	->success()
		// 	->send();
	}
	
	/**
     * Form builder.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public function form (Schema $schema) : Schema { return FeatureRequestFormBuilder::get($schema); }

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('feature-requests::livewire.feature-request-form.default');
	}

}
