<?php

namespace JLGR\FeatureRequests\Livewire;

use Filament\Actions\Contracts\HasActions;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Livewire\Component;
use JLGR\FeatureRequests\Filament\AdminTableBuilder;

class AdminTable extends Component implements HasForms, HasTable, HasActions
{
    use InteractsWithActions;
    use InteractsWithForms;
	use InteractsWithTable;

	/**
	 * Get the number of regions.
	 */
	public function mount ()
	{
	}

	/**
	 * Table builder.
	 * 
	 * @param  Table  $table
	 * 
	 * @return Table
	 */
	public function table (Table $table) : Table { return AdminTableBuilder::get($table); }

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('feature-requests::admin-table.default');
	}

}
