<?php

namespace JLGR\FeatureRequests\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendFeatureRequestNotification implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * Feature request id.
	 * 
	 * @var integer
	 */
	protected $featureRequestId;

	/**
	 * Create a new job instance.
	 * 
	 * @param  integer  $featureRequestId
	 * 
	 * @return void
	 */
	public function __construct ($featureRequestId)
	{
		$this->featureRequestId = $featureRequestId;

		$this->onQueue(config('jlgr.feature-requests.notifications.queue'));
	}

	/**
	 * Execute the job.
	 * Will be processed on the worker server.
	 * 
	 * @return void
	 */
	public function handle () : void {}

}
