<?php

namespace JLGR\FeatureRequests\Filament;

use Filament\Schemas\Schema;
use Filament\Schemas\Components\Grid;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\{ Components, Form };

class FeatureRequestFormBuilder
{

	/**
     * Build edit form.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public static function get (Schema $schema) : Schema
	{
		return $schema
			->components([
				Grid::make(12)
					->schema([
						TextInput::make('name')
							->label(__('Brief description (subject)'))
							->columnSpanFull()
							->required()
							->autofocus()
							->validationMessages([
								'required' => __('Subject is required.'),
							]),
						Textarea::make('description')
							->label(__('Describe the feature in detail'))
							->columnSpanFull()
							->rows(7)
							->required()
							->validationMessages([
								'required' => __('Description is required.'),
							]),
					]),
			])
			->statePath('data');
	}

}
