<?php

namespace JLGR\FeatureRequests;

use JLGR\FeatureRequests\Livewire\AdminTable;
use JLGR\FeatureRequests\Livewire\FeatureRequestForm;
use JLGR\FeatureRequests\Contracts\CreatesFeatureRequest;
use JLGR\FeatureRequests\Actions\CreateFeatureRequest;
use JLGR\FeatureRequests\Repositories\FeatureRequestRepository;
use JLGR\FeatureRequests\Models\FeatureRequest;
use JLGR\FeatureRequests\Observers\FeatureRequestObserver;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class FeatureRequestsServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// Publish the package's configuration file.
		$this->publishConfigFile();

		// Publish the package's migration file.
		$this->publishMigrations();
		
		// Load views.
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'feature-requests');

		// Register Livewire components.
		$this->registerLivewireComponents();

		// Register model observers.
		$this->registerObservers();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// Register action bindings.
		$this->registerActionBindings();

		// Register package repository.
		$this->registerRepository();

		// Merge config file.
		$this->mergeConfigFile();
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		Livewire::component('feature-requests::admin-table', AdminTable::class);
		Livewire::component('feature-requests::feature-request-form', FeatureRequestForm::class);
	}

	/**
	 * Register action bindings.
	 * 
	 * @return void
	 */
	protected function registerActionBindings ()
	{
		$this->app->singleton(
			CreatesFeatureRequest::class,
			CreateFeatureRequest::class
		);
	}

	/**
	 * Register the bug report repository.
	 * 
	 * @return void
	 */
	protected function registerRepository () : void
	{
		$this->app->bind(
			FeatureRequestRepository::class,
			fn ($app) => new FeatureRequestRepository
		);
	}

	/**
	 * Register observers.
	 * 
	 * @return void
	 */
	protected function registerObservers () : void
	{
		FeatureRequest::observe(FeatureRequestObserver::class);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/feature-requests.php' => config_path('jlgr/feature-requests.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/feature-requests.php',
			'jlgr.feature-requests'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
