<?php

namespace JLGR\FeatureRequests\Actions;

use JLGR\FeatureRequests\Models\FeatureRequest;
use JLGR\FeatureRequests\Contracts\CreatesFeatureRequest;
use JLGR\FeatureRequests\Enums\Status;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class CreateFeatureRequest implements CreatesFeatureRequest
{

	/**
	 * Process request feature form and send the message to the admin.
	 *
	 * @param  array  $input
	 * 
	 * @return void
	 */
	public function createFeatureRequest (array $input) : void
	{
		// Create feature request.
		$bugReport = FeatureRequest::create([
			'status' => Status::New->value,
			'user_id' => Auth::user()->id,
			'name' => Str::trim($input['name']),
			'description' => Str::trim($input['description']),
		]);
	}

}
