<?php

namespace JLGR\FeatureRequests\Queries;

use Illuminate\Database\Eloquent\Builder;
use JLGR\FeatureRequests\Enums\Status;
use JLGR\FeatureRequests\Models\FeatureRequest;
use JLGR\Kernel\Queries\Eloquent\BaseQuery;

class AllFeatureRequests extends BaseQuery
{

	/**
	 * Build a query for all feature requests.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Builder
	 */
	protected static function builder (array $params = []) : Builder
	{
		return static::newQuery(new FeatureRequest)

			// Filter on published countries.
			->when($params['status'] ?? false, fn (Builder $query, Status $status)
				=> $query
					->where('status', $status->value));
	}

}
