<?php

namespace JLGR\FeatureRequests\Observers;

use JLGR\FeatureRequests\Models\FeatureRequest;
use Illuminate\Support\Facades\Cache;
use JLGR\FeatureRequests\Jobs\SendFeatureRequestNotification;

class FeatureRequestObserver
{

	/**
	 * Handle the "created" event.
	 * 
	 * @param  \JLGR\FeatureRequests\Models\FeatureRequest  $featureRequest
	 */
	public function created (FeatureRequest $featureRequest)
	{
		$this->invalidateCache();

		// Send notification, id enabled.
		if (config('jlgr.feature-requests.notifications.enabled'))
		{
			// Dispatch job for sending the notification.
			SendFeatureRequestNotification::dispatch($featureRequest->id);
		}
	}

	/**
	 * Handle the "updated" event.
	 * 
	 * @param  \JLGR\FeatureRequests\Models\FeatureRequest  $featureRequest
	 */
	public function updated (FeatureRequest $featureRequest)
	{
		$this->invalidateCache();
	}

	/**
	 * Handle the "deleted" event.
	 * 
	 * @param  \JLGR\FeatureRequests\Models\FeatureRequest  $featureRequest
	 */
	public function deleted (FeatureRequest $featureRequest)
	{
		$this->invalidateCache();
	}

	/**
	 * Invalidate cache.
	 * 
	 * @return void
	 */
	private function invalidateCache () : void
	{
		Cache::tags(config('jlgr.feature-requests.cache.tag'))->flush();
	}

}
