<?php

namespace JLGR\FeatureRequests\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use JLGR\Kernel\Models\BaseModel;

class FeatureRequest extends BaseModel
{
	
	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'feature_requests';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * The user that submitted this feature request.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.feature-requests.user_model'));
	}

}
