<?php

namespace JLGR\FeatureRequests\Livewire;

use JLGR\FeatureRequests\Contracts\CreatesFeatureRequest;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Livewire\Component;
use JLGR\FeatureRequests\Filament\FeatureRequestFormBuilder;

class FeatureRequestForm extends Component implements HasForms
{
	use InteractsWithForms;

	/**
	 * The form's state.
	 * 
	 * @var array
	 */
	public ?array $data = [];

	/**
	 * Flag indicating the visibility of the message sent message.
	 */
	public $messageSent = false;
	
	/**
	 * Submit the form.
	 * 
	 * @return void
	 */
	public function submitForm (CreatesFeatureRequest $processor) : void
	{
		$this->validate();

		$processor->createFeatureRequest($this->data);

		$this->reset('data');
		$this->messageSent = true;

		// Notification::make()
		// 	->title(__('Feature request sent successfully!'))
		// 	->success()
		// 	->send();
	}
	
	/**
	 * Form builder.
	 * 
	 * @param  \Filament\Forms\Form $form
	 * 
	 * @return \Filament\Forms\Form
	 */
	public function form (Form $form) : Form { return FeatureRequestFormBuilder::get($form); }

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('feature-requests::livewire.feature-request-form.default');
	}

}
