<?php

namespace JLGR\FeatureRequests\Filament;

use Filament\Forms\{ Components, Form };

class FeatureRequestFormBuilder
{

	/**
	 * Build edit form.
	 * 
	 * @param  Form  $form
	 * 
	 * @return Form
	 */
	public static function get (Form $form) : Form
	{
		return $form
			->schema([
				Components\Grid::make(12)
					->schema([
						Components\TextInput::make('name')
							->label(__('Brief description (subject)'))
							->columnSpanFull()
							->required()
							->autofocus()
							->validationMessages([
								'required' => __('Subject is required.'),
							]),
						Components\Textarea::make('description')
							->label(__('Describe the feature in detail'))
							->columnSpanFull()
							->rows(7)
							->required()
							->validationMessages([
								'required' => __('Description is required.'),
							]),
					]),
			])
			->statePath('data');
	}

}
