<?php

namespace JLGR\FeatureRequests;

use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class FeatureRequestsServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// Publish the package's configuration file.
		$this->publishConfigFile();

		// Publish the package's migration file.
		$this->publishMigrations();
		
		// Load views.
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'feature-requests');

		// Register Livewire components.
		$this->registerLivewireComponents();

		// Register model observers.
		$this->registerObservers();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// Register action bindings.
		$this->registerActionBindings();

		// Register package repository.
		$this->registerRepository();

		// Merge config file.
		$this->mergeConfigFile();
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		Livewire::component('feature-requests::admin-table', \JLGR\FeatureRequests\Livewire\AdminTable::class);
		Livewire::component('feature-requests::feature-request-form', \JLGR\FeatureRequests\Livewire\FeatureRequestForm::class);
	}

	/**
	 * Register action bindings.
	 * 
	 * @return void
	 */
	protected function registerActionBindings ()
	{
		$this->app->singleton(
			\JLGR\FeatureRequests\Contracts\CreatesFeatureRequest::class,
			\JLGR\FeatureRequests\Actions\CreateFeatureRequest::class
		);
	}

	/**
	 * Register the bug report repository.
	 * 
	 * @return void
	 */
	protected function registerRepository () : void
	{
		$this->app->bind(
			\JLGR\FeatureRequests\Repositories\FeatureRequestRepository::class,
			fn ($app) => new \JLGR\FeatureRequests\Repositories\FeatureRequestRepository
		);
	}

	/**
	 * Register observers.
	 * 
	 * @return void
	 */
	protected function registerObservers () : void
	{
		\JLGR\FeatureRequests\Models\FeatureRequest::observe(\JLGR\FeatureRequests\Observers\FeatureRequestObserver::class);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/feature-requests.php' => config_path('jlgr/feature-requests.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/feature-requests.php',
			'jlgr.feature-requests'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
