<?php

namespace JLGR\FeatureRequests\Enums;

enum Status : string
{

	// Cases...
	case Implemented    = 'implemented';
	case New            = 'new';
	case OnHold       	= 'on-hold';
	case Pending        = 'pending';
	case Rejected       = 'rejected';
	case Scheduled      = 'scheduled';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::Implemented 	=> __('Implemented'),
			self::New			=> __('New'),
			self::OnHold		=> __('On hold'),
			self::Pending		=> __('Pending'),
			self::Rejected 		=> __('Rejected'),
			self::Scheduled		=> __('Scheduled'),
		};
	}

}
