<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use JLGR\FeatureRequests\Enums\Status;

return new class extends Migration
{

	/**
	 * Run the migrations.
	 */
	public function up () : void
	{
		Schema::create('feature_requests', function (Blueprint $table) {
			$table->id();
			$table->foreignId('user_id')->constrained()->cascadeOnDelete();
			$table->enum('status', [
				Status::New->value,
				Status::Pending->value,
				Status::OnHold->value,
				Status::Scheduled->value,
				Status::Implemented->value,
				Status::Rejected->value,
			])->default(Status::New->value);
			$table->string('name');
			$table->text('description')->nullable();
			$table->boolean('points_granted')->default(FALSE);
			$table->boolean('archived')->default(FALSE);
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down () : void
	{
		Schema::dropIfExists('feature_requests');
	}

};
