<?php

namespace JLGR\Enquiries\Repositories;

use JLGR\Kernel\Enums\CacheDuration;
use JLGR\Kernel\Repositories\BaseRepository;
use JLGR\Enquiries\Enums\Status;
use JLGR\Enquiries\Queries\AllEnquiries;

class EnquiryRepository extends BaseRepository
{

	/**
	 * Constructor.
	 */
	public function __construct ()
	{
		// Indicates whether caching is enabled.
		$this->useCaching = config('jlgr.enquiries.cache.enabled');

		// Get default cache tags.
		$this->cacheTag = config('jlgr.enquiries.cache.tag');
	}

	/**
	 * Get number of new messages.
	 * 
	 * @param  array  $params
	 * 
	 * @return int
	 */
	public function getNumberOfNewEnquiries (array $params = []) : int
	{
		$params = array_merge($params, [ 'status' => Status::New ]);

		return $this->retrieveFromCache(
			cacheKey: "number-of-new-enquiries",
			callback: fn () => AllEnquiries::count($params),
			duration: CacheDuration::OneHour
		);
	}
	
}
