<?php

namespace JLGR\Enquiries\Queries;

use JLGR\Enquiries\Enums\Status;
use JLGR\Enquiries\Models\Enquiry;
use Illuminate\Database\Eloquent\Builder;
use JLGR\Kernel\Queries\Eloquent\BaseQuery;

class AllEnquiries extends BaseQuery
{

	/**
	 * Build a query for all countries.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Builder
	 */
	protected static function builder (array $params = []) : Builder
	{
		return static::newQuery(new Enquiry)

			// Filter on published countries.
			->when($params['status'] ?? false, fn (Builder $query, Status $status)
				=> $query
					->where('status', $status->value));
	}

}
