<?php

namespace JLGR\Enquiries\Observers;

use JLGR\Enquiries\Models\Enquiry;
use Illuminate\Support\Facades\Cache;
use JLGR\Enquiries\Jobs\SendEnquirySubmittedNotification;

class EnquiryObserver
{

	/**
     * Handle the "created" event.
     *
     * @param Enquiry $enquiry
     */
    public function created (Enquiry $enquiry)
	{
		$this->invalidateCache();

		// Send notification, id enabled.
		if (config('jlgr.enquiries.notifications.enabled'))
		{
			// Dispatch job for sending the notification.
			SendEnquirySubmittedNotification::dispatch($enquiry->id);
		}
	}

	/**
     * Handle the "updated" event.
     *
     * @param Enquiry $enquiry
     */
    public function updated (Enquiry $enquiry)
	{
		$this->invalidateCache();
	}

	/**
     * Handle the "deleted" event.
     *
     * @param Enquiry $enquiry
     */
    public function deleted (Enquiry $enquiry)
	{
		$this->invalidateCache();
	}

	/**
	 * Invalidate cache.
	 * 
	 * @return void
	 */
	private function invalidateCache () : void
	{
		Cache::tags(config('jlgr.enquiries.cache.tag'))->flush();
	}

}
