<?php

namespace JLGR\Enquiries\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use JLGR\Kernel\Models\BaseModel;
use JLGR\Enquiries\Events\EnquirySubmitted;

class Enquiry extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'enquiries';

	/**
	 * The attributes that are protected from mass assignment. An empty
	 * array means all fields are mass assignable.
	 * 
	 * @var array
	 */
	protected $guarded = [];

	/**
	 * Events to be fired by native model events.
	 * 
	 * @var array
	 */
	protected $dispatchesEvents = [
		'created' => EnquirySubmitted::class,
	];

	/**
	 * The user that submitted this feature request.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.enquiries.user_model'));
	}

}
