<?php

namespace JLGR\Enquiries\Livewire;

use Filament\Actions\Contracts\HasActions;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Schemas\Schema;
use JLGR\Enquiries\Contracts\CreatesEnquiry;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Livewire\Component;
use JLGR\Enquiries\Filament\EnquiryFormBuilder;

class EnquiryForm extends Component implements HasForms, HasActions
{
	use InteractsWithActions;
    use InteractsWithForms;

	/**
	 * The form's state.
	 * 
	 * @var array
	 */
	public ?array $data = [];

	/**
	 * Flag indicating the visibility of the message sent message.
	 */
	public $messageSent = false;

	/**
	 * Flag indicating the subject field should be used.
	 * 
	 * @var boolean
	 */
	public $withSubject = false;

	/**
	 * Mount the component.
	 * 
	 * @param  boolean  $withSubject
	 * 
	 * @return void
	 */
	public function mount ($withSubject = false) : void
	{
		$this->withSubject = $withSubject;
	}
	
	/**
	 * Submit the form.
	 * 
	 * @return void
	 */
	public function submitForm (CreatesEnquiry $processor) : void
	{
		$this->validate();

		$processor->createEnquiry($this->data);

		$this->reset('data');
		$this->messageSent = true;
	}
	
	/**
     * Form builder.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public function form (Schema $schema) : Schema { return EnquiryFormBuilder::get($schema, $this->withSubject); }

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('enquiries::enquiry-form.default');
	}

}
