<?php

namespace JLGR\Enquiries\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendEnquirySubmittedNotification implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * Enquiry id.
	 * 
	 * @var integer
	 */
	protected $enquiryId;

	/**
	 * Create a new job instance.
	 * 
	 * @param  integer  $enquiryId
	 * 
	 * @return void
	 */
	public function __construct ($enquiryId)
	{
		$this->enquiryId = $enquiryId;

		$this->onQueue(config('jlgr.enquiries.notifications.queue'));
	}

	/**
	 * Execute the job.
	 * Will be processed on the worker server.
	 * 
	 * @return void
	 */
	public function handle () : void {}

}
