<?php

namespace JLGR\Enquiries\Filament;

use Filament\Schemas\Schema;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\{ Components, Form };
use Illuminate\Support\Facades\Auth;

class EnquiryFormBuilder
{

	/**
     * Build edit form.
     *
     * @param Schema $schema
     * @param  boolean  $withSubject
     *
     * @return Schema
     */
    public static function get (Schema $schema, ?bool $withSubject = false) : Schema
	{
		return $schema
			->components([
				TextInput::make('name')
					->columnSpanFull()
					->label(__('Name'))
					->required()
					->hidden(Auth::check())
					->validationMessages([
						'required' => __('Name is required.'),
					]),
				TextInput::make('email')
					->columnSpanFull()
					->label(__('E-mail address'))
					->email()
					->required()
					->hidden(Auth::check())
					->validationMessages([
						'required' => __('E-mail address is required.'),
					]),
				TextInput::make('subject')
					->columnSpanFull()
					->label(__('Subject'))
					->required()
					->visible($withSubject)
					->validationMessages([
						'required' => __('Subject is required.'),
					]),
				Textarea::make('message')
					->columnSpanFull()
					->label(__('Message'))
					->helperText(__('Please note: this form is not meant for support requests.'))
					->rows(3)
					->required()
					->validationMessages([
						'required' => __('Message is required.'),
					]),
			])
			->statePath('data');
	}

}
