<?php

namespace JLGR\Enquiries\Filament;

use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\ViewColumn;
use JLGR\Enquiries\Enums\Status;
use JLGR\Enquiries\Models\Enquiry;
use Filament\Support\Enums\FontWeight;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;


class AdminTableBuilder
{

	/**
	 * Build table renderer.
	 * 
	 * @param  Table  $table
	 * 
	 * @return Table
	 */
	public static function get (Table $table) : Table
	{
		return $table
			->query(static::getQuery())
			->columns(static::getColumns())
			->filters(static::getFilters())
			->recordActions(static::getActions())
			->defaultSort('created_at', 'desc');
	}

	/**
     * Build query for the tables data source.
     *
     * @return Builder
     */
    protected static function getQuery () : Builder
	{
		return Enquiry::query();
	}

	/**
	 * Define columns for the table grid.
	 * 
	 * @return array
	 */
	protected static function getColumns () : array
	{
		return [
			TextColumn::make('created_at')
				->label(__('Date'))
				->date('d-m-Y')
				->sortable(),
			TextColumn::make('subject')
				->label(__('Subject'))
				->sortable()
				->searchable()
				->weight(FontWeight::Bold),
			TextColumn::make('name')
				->label(__('Name'))
				->sortable()
				->searchable(),
			TextColumn::make('email')
				->label(__('E-mail'))
				->sortable()
				->searchable()
				->copyable()
				->copyMessage(__('E-mail address copied'))
				->copyMessageDuration(1500),
			TextColumn::make('message')
				->label(__('Message'))
				->words(7)
				->searchable(),
			ViewColumn::make('status')
				->label(__('Status'))
				->view('enquiries::partials.status')
				->sortable()
				->state(fn (Enquiry $record) : Enquiry => $record),
		];
	}

	/**
	 * Define filters for this table.
	 * 
	 * @return array
	 */
	protected static function getFilters () : array
	{
		return [
			SelectFilter::make('status')
				->label(__('Status'))
				->options([
					Status::New->value => Status::New->getLabel(),
					Status::Pending->value => Status::Pending->getLabel(),
					Status::Completed->value => Status::Completed->getLabel(),
					Status::Ignored->value => Status::Ignored->getLabel(),
					Status::Spam->value => Status::Spam->getLabel(),
				])
		];
	}

	/**
	 * Define filters for this table.
	 * 
	 * @return array
	 */
	protected static function getActions () : array
	{
		return [
			// Action::make('edit')
			// 	->icon('heroicon-o-pencil')
			// 	->iconButton()
			// 	->url(
			// 		fn (Entity $record) : string
			// 			=> route('entities.edit', [ 'entityCategory' => $record->category->key, 'entity' => $record->id ])
			// 	),
		];
	}

}
