<?php

namespace JLGR\Enquiries\Events;

use JLGR\Enquiries\Models\Enquiry;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class EnquirySubmitted
{
	use Dispatchable;
	use InteractsWithSockets;
	use SerializesModels;

	/**
     * The enquiry.
     *
     * @var Enquiry
     */
    public $enquiry;

	/**
     * Create a new event instance.
     *
     * @param Enquiry $enquiry
     */
    public function __construct (Enquiry $enquiry)
	{
		$this->enquiry = $enquiry;
	}

}
