<?php

namespace JLGR\Enquiries\Enums;

enum Status : string
{

	// Cases...
	case Completed      = 'completed';
	case Ignored        = 'ignored';
	case New            = 'new';
	case Pending        = 'pending';
	case Spam           = 'spam';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::Completed 	=> __('Completed'),
			self::Ignored		=> __('Ignored'),
			self::New			=> __('New'),
			self::Pending		=> __('Pending'),
			self::Spam 			=> __('Spam'),
		};
	}

}
