<?php

namespace JLGR\Enquiries\Actions;

use Illuminate\Support\Facades\Auth;
use JLGR\Enquiries\Contracts\CreatesEnquiry;
use JLGR\Enquiries\Enums\Status;
use JLGR\Enquiries\Models\Enquiry;

class CreateEnquiry implements CreatesEnquiry
{

	/**
	 * Submit contact form.
	 *
	 * @param  array  $input
	 * 
	 * @return void
	 */
	public function createEnquiry (array $input) : void
	{
		// Store message.
		$enquiry = Enquiry::create([
			'status' => Status::New->value,
			'name' => Auth::check() ? Auth::user()->name : trim($input['name']),
			'email' => Auth::check() ? Auth::user()->email : trim($input['email']),
			'subject' => trim($input['subject'] ?? ''),
			'message' => trim($input['message']),
			'newsletter' => $input['newsletter'] ?? false
		]);
	}

}
