<?php

use JLGR\Enquiries\Enums\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

	/**
	 * Run the migrations.
	 */
	public function up () : void
	{
		Schema::create('enquiries', function (Blueprint $table) {
			$table->id();
			$table->foreignId('user_id')->nullable()->constrained('users')->cascadeOnDelete();
			$table->enum('status', [
				Status::New->value,
				Status::Pending->value,
				Status::Completed->value,
				Status::Ignored->value,
				Status::Spam->value,
			])->default(Status::New->value);
			$table->string('name');
			$table->string('email');
			$table->string('subject')->nullable();
			$table->text('message')->nullable();
			$table->boolean('newsletter')->default(FALSE);
			$table->boolean('archived')->default(FALSE);
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down () : void
	{
		Schema::dropIfExists('enquiries');
	}

};
