<?php

namespace JLGR\EmailCollector\Repositories;

use Illuminate\Database\Eloquent\Collection;
use JLGR\Kernel\Enums\CacheDuration;
use JLGR\Kernel\Repositories\BaseRepository;
use JLGR\EmailCollector\Queries\AllCollectedEmails;
use JLGR\EmailCollector\Enums\Status;

class EmailCollectorRepository extends BaseRepository
{

	/**
	 * Constructor.
	 */
	public function __construct ()
	{
		// Indicates whether caching is enabled.
		$this->useCaching = config('jlgr.email-collector.cache.enabled');

		// Get default cache tags.
		$this->cacheTag = config('jlgr.email-collector.cache.tag');
	}

	/**
     * Get number of new bug reports.
     *
     * @param  array  $params
     *
     * @return Collection
     */
    public function getNumberOfNewBugReports (array $params = []) : Collection
	{
		$params = array_merge($params, [ 'status' => Status::New ]);

		return $this->retrieveFromCache(
			cacheKey: "all-collected-emails",
			callback: fn () => AllCollectedEmails::collection($params),
			duration: CacheDuration::OneHour
		);
	}
	
}
