<?php

namespace JLGR\EmailCollector\Queries;

use Illuminate\Database\Eloquent\Builder;
use JLGR\EmailCollector\Enums\Status;
use JLGR\EmailCollector\Models\CollectedEmail;
use JLGR\Kernel\Queries\Eloquent\BaseQuery;

class AllCollectedEmails extends BaseQuery
{

	/**
	 * Build a query for all collected e-mails.
	 * 
	 * @param  array  $params  Optional array with filter params.
	 * 
	 * @return Builder
	 */
	protected static function builder (array $params = []) : Builder
	{
		return static::newQuery(new CollectedEmail)

			// Filter on published records.
			->when($params['status'] ?? false, fn (Builder $query, Status $status)
				=> $query
					->where('status', $status->value));
	}

}
