<?php

namespace JLGR\EmailCollector\Observers;

use Illuminate\Support\Facades\Cache;
use JLGR\EmailCollector\Jobs\SendEmailCollectedNotification;
use JLGR\EmailCollector\Models\CollectedEmail;

class CollectedEmailObserver
{

	/**
     * Handle the "created" event.
     *
     * @param CollectedEmail $collectedEmail
     */
    public function created (CollectedEmail $collectedEmail)
	{
		$this->invalidateCache();

		// Send notification, id enabled.
		if (config('jlgr.email-collector.notifications.enabled'))
		{
			// Dispatch job for sending the notification.
			SendEmailCollectedNotification::dispatch($collectedEmail->id);
		}
	}

	/**
     * Handle the "updated" event.
     *
     * @param CollectedEmail $collectedEmail
     */
    public function updated (CollectedEmail $collectedEmail)
	{
		$this->invalidateCache();
	}

	/**
     * Handle the "deleted" event.
     *
     * @param CollectedEmail $collectedEmail
     */
    public function deleted (CollectedEmail $collectedEmail)
	{
		$this->invalidateCache();
	}

	/**
	 * Invalidate cache.
	 * 
	 * @return void
	 */
	private function invalidateCache () : void
	{
		Cache::tags(config('jlgr.email-collector.cache.tag'))->flush();
	}

}
