<?php

namespace JLGR\EmailCollector\Livewire;

use Filament\Actions\Contracts\HasActions;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Schemas\Schema;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Livewire\Component;
use JLGR\EmailCollector\Contracts\StoresEmailAddress;
use JLGR\EmailCollector\Filament\CollectEmailFormBuilder;

class CollectEmailForm extends Component implements HasForms, HasActions
{
	use InteractsWithActions;
    use InteractsWithForms;

	/**
	 * The form's state.
	 * 
	 * @var array
	 */
	public ?array $data = [];

	/**
	 * Flag indicating the visibility of the message sent message.
	 */
	public $messageSent = true;
	
	/**
	 * Submit the form.
	 * 
	 * @return void
	 */
	public function submitForm (StoresEmailAddress $processor) : void
	{
		$this->validate();

		$processor->storeEmailAddress($this->data);

		$this->reset('data');
		$this->dispatch('notify-success');
	}
	
	/**
     * Form builder.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public function form (Schema $schema) : Schema { return CollectEmailFormBuilder::get($schema); }

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('email-collector::collect-email-form.default');
	}

}
