<?php

namespace JLGR\EmailCollector\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendEmailCollectedNotification implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * Enquiry id.
	 * 
	 * @var integer
	 */
	protected $collectedEmailId;

	/**
	 * Create a new job instance.
	 * 
	 * @param  integer  $collectedEmailId
	 * 
	 * @return void
	 */
	public function __construct ($collectedEmailId)
	{
		$this->collectedEmailId = $collectedEmailId;

		$this->onQueue(config('jlgr.email-collector.notifications.queue'));
	}

	/**
	 * Execute the job.
	 * Will be processed on the worker server.
	 * 
	 * @return void
	 */
	public function handle () : void {}

}
