<?php

namespace JLGR\EmailCollector\Filament;

use Filament\Schemas\Schema;
use Filament\Schemas\Components\Grid;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\{ Components, Form };

class CollectEmailFormBuilder
{

	/**
     * Build edit form.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public static function get (Schema $schema) : Schema
	{
		return $schema
			->components([
				Grid::make(2)
					->schema([
						TextInput::make('name')
							->columnSpan(1)
							->label(__('Name'))
							->required()
							->validationMessages([
								'required' => __('Name is required.'),
							]),
						TextInput::make('email')
							->columnSpan(1)
							->label(__('E-mail address'))
							->email()
							->required()
							->validationMessages([
								'required' => __('E-mail address is required.'),
							]),
					]),
				Grid::make(2)
					->schema([
						Textarea::make('message')
							->columnSpanFull()
							->label(__('Little about yourself'))
							->helperText(__('Where do you fly, what do you fly, etc.'))
							->rows(3)
							->required()
							->validationMessages([
								'required' => __('This field is required.'),
							]),
					])
			])
			->statePath('data');
	}

}
