<?php

namespace JLGR\EmailCollector\Events;

use JLGR\EmailCollector\Models\CollectedEmail;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class EmailCollected
{
	use Dispatchable;
	use InteractsWithSockets;
	use SerializesModels;

	/**
     * The collected e-mail.
     *
     * @var CollectedEmail
     */
    public $collectedEmail;

	/**
     * Create a new event instance.
     *
     * @param CollectedEmail $collectedEmail
     */
    public function __construct (CollectedEmail $collectedEmail)
	{
		$this->collectedEmail = $collectedEmail;
	}

}
