<?php

namespace JLGR\EmailCollector\Enums;

enum Status : string
{

	// Cases...
	case Duplicate      = 'duplicate';
	case Ignored      	= 'ignored';
	case New            = 'new';
	case Processed      = 'processed';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::Duplicate		=> __('Duplicate'),
			self::Ignored		=> __('Ignored'),
			self::New			=> __('New'),
			self::Processed		=> __('Processed'),
		};
	}
	
}
