<?php

namespace JLGR\EmailCollector\Actions;

use Illuminate\Support\Str;
use JLGR\EmailCollector\Contracts\StoresEmailAddress;
use JLGR\EmailCollector\Jobs\SendEmailCollectedNotification;
use JLGR\EmailCollector\Models\CollectedEmail;

class StoreEmailAddress implements StoresEmailAddress
{

	/**
	 * Store e-mail address
	 *
	 * @param  array  $input
	 * 
	 * @return void
	 */
	public function storeEmailAddress (array $input) : void
	{
		// Store e-mail address.
		$collectedEmail = CollectedEmail::create([
			'status' => 'new',
			'name' => Str::trim($input['name']),
			'email' => Str::trim($input['email']),
			'message' => Str::trim($input['message']),
		]);

		// Notify admin.
		SendEmailCollectedNotification::dispatch($collectedEmail->id);
	}

}
